/* [Global settings] */

// Global rescaler (X*1mm)
rescaler = 1; 

// Min. facet render level (mm)
$fs = 0.1;  // Don't generate smaller facets than 0.1 mm

// Min angles render level (deg)
$fa = 5;    // Don't generate larger angles than 5 degrees

// Enable helper geometry
debug = true; // [True, False]

// Horiz. spacing between debug parts (mm)
debug_spacing_y = 10;

// Vert. spacing between debug parts (mm)
debug_spacing_z = 20; 


/* [catch dimensions] */

// Thickness of catch (mm)
catch_y = 3;

// Width of catch (mm)
catch_x = 4;

// Height of catch (mm)
catch_z = 10.8; //10.8 


/* [handle dimensions] */

// Thickness of handle (mm)
handle_y = 3;

// Width of handle (mm)
handle_x = 14.8;

// Height of handle (mm)
handle_z = 10; 


/* [tube dimensions] */

// lenght of tube (mm)
tube_y = 15; //surface to surface 

// Diameter of tube (mm)
tube_d = 5.5; //7.2 actual less 0.1 mm


/* [ball dimensions] */

// Helpers
if (debug) helpers();



// Main geometry
// *************
color("Yellow") clip();


// Intermediate components
// ***********************

module clip() {
    translate([0,0-tube_y/2-handle_y/2,0]) handle();
    tube();
    translate([0,0+tube_y/2-handle_y/2,0]) catch();
}

// Core geometric primitives
// *************************

module handle() {

    translate([0,2.5,0]) difference() {
        hull(){
            translate([0,0,0]) sphere(catch_z/2, $fa=5, $fs=0.1);
            translate([catch_z*0.9,0,0]) sphere(catch_z/4, $fa=5, $fs=0.1);
        }
        translate([0,2.5,0]) cube([catch_z*3,6,15], center=true);
    }
}

module tube() {
   color("Red") rotate([90,0,0]) cylinder(h=tube_y, r1=(tube_d/2), r2=(tube_d/2), center=true);
}

module catch() {
    color("Green") intersection() {
        cube([catch_x,catch_y,catch_z], center=true);
        rotate([90,0,0]) cylinder(h=catch_y, r1=(catch_z/2), r2=(catch_z/2), center=true);
    }
}

// debug display 
module helpers() {
    
    translate([0, 0, debug_spacing_z * -1]) clip();
    
    translate([0, 0 - debug_spacing_y*2 - handle_y/2, debug_spacing_z * -2]) handle();
    translate([0, 0, debug_spacing_z * -2]) tube();
    translate([0, 0 + debug_spacing_y*2 - catch_y/2, debug_spacing_z * -2]) catch();
}

echo(version=version());
// Written by Ed Watson <mail@edwardwatson.co.uk>
//
// To the extent possible under law, the author(s) have dedicated all
// copyright and related and neighboring rights to this software to the
// public domain worldwide. This software is distributed without any
// warranty.
//
// You should have received a copy of the CC0 Public Domain
// Dedication along with this software.
// If not, see <http://creativecommons.org/publicdomain/zero/1.0/>.

              